<?php
/**
 * WebhookIgnoreReport
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 */

/**
 * Infobip Client API Libraries OpenAPI Specification
 *
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit the class manually.
 */

namespace Infobip\Model;

use ArrayAccess;
use Infobip\ObjectSerializer;

/**
 * WebhookIgnoreReport Class Doc Comment
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class WebhookIgnoreReport implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'WebhookIgnoreReport';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'bulkId' => 'string',
        'price' => '\Infobip\Model\MessagePrice',
        'status' => '\Infobip\Model\MessageStatus',
        'error' => '\Infobip\Model\MessageError',
        'messageId' => 'string',
        'doneAt' => '\DateTime',
        'messageCount' => 'int',
        'sentAt' => '\DateTime',
        'to' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'bulkId' => null,
        'price' => null,
        'status' => null,
        'error' => null,
        'messageId' => null,
        'doneAt' => 'date-time',
        'messageCount' => 'int32',
        'sentAt' => 'date-time',
        'to' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'bulkId' => 'bulkId',
        'price' => 'price',
        'status' => 'status',
        'error' => 'error',
        'messageId' => 'messageId',
        'doneAt' => 'doneAt',
        'messageCount' => 'messageCount',
        'sentAt' => 'sentAt',
        'to' => 'to'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'bulkId' => 'setBulkId',
        'price' => 'setPrice',
        'status' => 'setStatus',
        'error' => 'setError',
        'messageId' => 'setMessageId',
        'doneAt' => 'setDoneAt',
        'messageCount' => 'setMessageCount',
        'sentAt' => 'setSentAt',
        'to' => 'setTo'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'bulkId' => 'getBulkId',
        'price' => 'getPrice',
        'status' => 'getStatus',
        'error' => 'getError',
        'messageId' => 'getMessageId',
        'doneAt' => 'getDoneAt',
        'messageCount' => 'getMessageCount',
        'sentAt' => 'getSentAt',
        'to' => 'getTo'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }





    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['bulkId'] = $data['bulkId'] ?? null;
        $this->container['price'] = $data['price'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
        $this->container['error'] = $data['error'] ?? null;
        $this->container['messageId'] = $data['messageId'] ?? null;
        $this->container['doneAt'] = $data['doneAt'] ?? null;
        $this->container['messageCount'] = $data['messageCount'] ?? null;
        $this->container['sentAt'] = $data['sentAt'] ?? null;
        $this->container['to'] = $data['to'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets bulkId
     *
     * @return string|null
     */
    public function getBulkId()
    {
        return $this->container['bulkId'];
    }

    /**
     * Sets bulkId
     *
     * @param string|null $bulkId The ID that uniquely identifies the request.
     *
     * @return self
     */
    public function setBulkId($bulkId)
    {
        $this->container['bulkId'] = $bulkId;

        return $this;
    }

    /**
     * Gets price
     *
     * @return \Infobip\Model\MessagePrice|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param \Infobip\Model\MessagePrice|null $price Sent message price.
     *
     * @return self
     */
    public function setPrice($price)
    {
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets status
     *
     * @return \Infobip\Model\MessageStatus|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param \Infobip\Model\MessageStatus|null $status Indicates whether the message is successfully sent, not sent, delivered, not delivered, waiting for delivery or any other possible status.
     *
     * @return self
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets error
     *
     * @return \Infobip\Model\MessageError|null
     */
    public function getError()
    {
        return $this->container['error'];
    }

    /**
     * Sets error
     *
     * @param \Infobip\Model\MessageError|null $error Indicates whether the error occurred during the query execution.
     *
     * @return self
     */
    public function setError($error)
    {
        $this->container['error'] = $error;

        return $this;
    }

    /**
     * Gets messageId
     *
     * @return string|null
     */
    public function getMessageId()
    {
        return $this->container['messageId'];
    }

    /**
     * Sets messageId
     *
     * @param string|null $messageId The ID that uniquely identifies the message sent.
     *
     * @return self
     */
    public function setMessageId($messageId)
    {
        $this->container['messageId'] = $messageId;

        return $this;
    }

    /**
     * Gets doneAt
     *
     * @return \DateTime|null
     */
    public function getDoneAt()
    {
        return $this->container['doneAt'];
    }

    /**
     * Sets doneAt
     *
     * @param \DateTime|null $doneAt Tells when the message was finished processing by Infobip (ie. delivered to destination, delivered to destination network, etc.).
     *
     * @return self
     */
    public function setDoneAt($doneAt)
    {
        $this->container['doneAt'] = $doneAt;

        return $this;
    }

    /**
     * Gets messageCount
     *
     * @return int|null
     */
    public function getMessageCount()
    {
        return $this->container['messageCount'];
    }

    /**
     * Sets messageCount
     *
     * @param int|null $messageCount The number of sent message segments.
     *
     * @return self
     */
    public function setMessageCount($messageCount)
    {
        $this->container['messageCount'] = $messageCount;

        return $this;
    }

    /**
     * Gets sentAt
     *
     * @return \DateTime|null
     */
    public function getSentAt()
    {
        return $this->container['sentAt'];
    }

    /**
     * Sets sentAt
     *
     * @param \DateTime|null $sentAt Tells when the message was sent. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.
     *
     * @return self
     */
    public function setSentAt($sentAt)
    {
        $this->container['sentAt'] = $sentAt;

        return $this;
    }

    /**
     * Gets to
     *
     * @return string|null
     */
    public function getTo()
    {
        return $this->container['to'];
    }

    /**
     * Sets to
     *
     * @param string|null $to The message destination address.
     *
     * @return self
     */
    public function setTo($to)
    {
        $this->container['to'] = $to;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    public function offsetGet($offset): mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    public function jsonSerialize(): mixed
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
