<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('fire_base_tokens', function (Blueprint $table) {
            $table->id();
            $table->integer('tokenable_id')->nullable(); // tokenable_id column, int(11), nullable
            $table->string('tokenable_type')->nullable(); // tokenable_type column, varchar(255), nullable
            $table->text('token')->nullable(); // token column, text, nullable
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fire_base_tokens');
    }
};
